declare @ActivityID uniqueidentifier
declare @Duration int
declare @Duration2 int

set @ActivityID = '47FDF227-3207-41F7-A595-B5A0755C5227'

--used for the first query
set @Duration = 60
--used for all queries after the first
set @duration2 = 300


/* Use the ActivityID and WorkflowAssociationID to pull the specific SQL trace, to be run vs. InteractionAudit_xxx */

SELECT [Name]
      ,[FileName]
      ,[StartDate]
      ,[EndDate]
      ,[Duration] as 'Duration in seconds'
	  ,[Duration]/60 as 'Duration in minutes'
	  ,[Duration]/60/60 as 'Duration in hours'
      ,[QueryString]
      ,[Status]
      ,[ErrorMessage]
      ,[Context]
  FROM [dbo].[SQLTraceLog]
  Where WorkflowAssociationInstanceID = 937 And ActivtyID = @activityID --'AFADEFEA-3B95-4FD1-B58F-39D27E28913B' 
	and [Duration] >= @duration
  order by [Duration] desc


/* Search all SQLTraceLog for longest running queries, to be run vs. InteractionAudit_xxx */

SELECT [Name]
      ,[FileName]
      ,[StartDate]
      ,[EndDate]
      ,[Duration] as 'Duration in seconds'
	  ,[Duration]/60 as 'Duration in minutes'
	  ,[Duration]/60/60 as 'Duration in hours'
      ,[QueryString]
      ,[Status]
      ,[Result]
      ,[ErrorMessage]
      ,[Context]
  FROM [dbo].[SQLTraceLog]
  WHERE datediff(month,[EndDate],getdate()) <= 1 and [Duration] >= @duration2
  order by [Duration] desc
  
/* Search all SQLTraceLog for longest running queries, by RPI object name, to be run vs. InteractionAudit_xxx */

SELECT distinct 
[FileName], count(*) as 'Count'
FROM [dbo].[SQLTraceLog]
WHERE datediff(month,[EndDate],getdate()) <= 1 and [Duration] >= @duration2
group by [FileName]
order by 'Count' desc

/* By date, how many RPI queries completed in greater than 5 minutes, to be run vs. InteractionAudit_xxx */

SELECT count(*)
FROM [dbo].[SQLTraceLog]
WHERE datediff(month,[EndDate],getdate()) <= 1 and [Duration] >= @duration2

/* By date, how many RPI queries completed in less than 5 minutes, to be run vs. InteractionAudit_xxx */

SELECT count(*)
FROM [dbo].[SQLTraceLog]
WHERE datediff(month,[EndDate],getdate()) <= 1 and [Duration] <= @duration2